//===============================================================================
// Microsoft patterns & practices Enterprise Library
// Configuration Application Block
//===============================================================================
// Copyright  Microsoft Corporation.  All rights reserved.
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT
// LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.
//===============================================================================

using Microsoft.VisualStudio.QualityTools.UnitTesting.Framework;

namespace Microsoft.Practices.EnterpriseLibrary.Configuration.Injection.Tests
{
	[TestClass]
	public class GenericInjectionFactoryFixture
	{
		[TestMethod]
		public void CanCreateGenericObjectWithObjectConfiguration()
		{
			InjectionFactory<GenericObject, GenericObjectConfiguration> factory = new InjectionFactory<GenericObject,GenericObjectConfiguration>();
			GenericObject o = factory.Create(new GenericObjectConfiguration("bob"));

			Assert.AreEqual<string>("bob", o.Name);
		}

		class GenericObject
		{
			private readonly string name;

			public GenericObject(string name)
			{
				this.name = name;
			}

			public string Name
			{
				get { return name; }
			}
		}

		
		[PropertyParameterAttribute(0, typeof(string), "Name")]
		class GenericObjectConfiguration
		{
			private readonly string name;

			public GenericObjectConfiguration(string name)
			{
				this.name = name;
			}

			public string Name
			{
				get { return name; }
			}
		}
	}
}
